{
	"addressElixir":{
		"type":"item",
		"age":"steamAge",
		"category":"edible",
		"picture":{"file":"addressElixir.atf"},
		"name":{"EN":"address elixir",
				"FR":"élixir d'adresse"},
		"description":{"EN":"The address elixir used to temporary increase your address and your rapidity.",
					   "FR":"L'élixir d'adresse augmente temporairement votre adresse et votre rapidité."},
		"use":{
			"quantity":-1,
			"gainTemporaryItem":{"increasedAddress":{"apothecary":3}},
			"xpSecondaryCharacteristic":{"willpower":8},
			"effect":"bonusEffect"
		},
		"maxQuantity":{"apothecary":1},
		"full":{"EN":{"D":["I have too many address elixirs."]},
				"FR":{"D":["J'ai le maximum d'élixirs d'adresse."]}},
		"produce":[{
				"workshop":"laboratory",
				"no":9,
				"time":8.5,
				"gainItem":{"addressElixir":1},
				"sound":"soundBottle",
				"bonusSkill":"apothecary",
				"costRessource":{"medicinalHerbs":9, "crystals":2},
				"costPrimaryCharacteristic":{"stamina":17},
				"xpSecondaryCharacteristic":{"willpower":17},
				"xpSkill":{"apothecary":17},
				"repeat":true,
				"quantity":-8
		}]
	},
	"beer":{
		"type":"item",
		"age":"ironAge",
		"category":"edible",
		"picture":{"file":"beer.atf"},
		"name":{"EN":"beer",
				"FR":"bière"},
		"description":{"EN":"Beer used to restore your stamina.",
					   "FR":"La bière vous permet de récupérer de l'énergie."},
		"use":{
			"quantity":-1,
			"gainTemporaryItem":{"foodBonusBeer":60},
			"gainPrimaryCharacteristic":{"stamina":{"strength":0.3}},
			"xpSecondaryCharacteristic":{"strength":3}
		},
		"maxQuantity":{"alcohols":1},
		"full":{"EN":{"D":["I have too many beer."]},
				"FR":{"D":["J'ai le maximum de bières."]}}
	},
	"boiledMeat":{
		"type":"item",
		"age":"etherAge",
		"category":"edible",
		"picture":{"file":"boiledMeat.atf"},
		"name":{"EN":"boiled meat",
				"FR":"viande bouillie"},
		"description":{"EN":"Boiled meat used to restore your stamina and gain a temporary bonus to endurance and rapidity.",
					   "FR":"La viande bouillie vous permet de récupérer de l'énergie et permet de gagner un bonus temporairement en endurance et en rapidité."},
		"use":{
			"quantity":-1,
			"gainTemporaryItem":{"foodBonusBoiledMeat":60},
			"gainPrimaryCharacteristic":{"stamina":{"endurance":0.08, "rapidity":0.08}},
			"xpSecondaryCharacteristic":{"endurance":0.8, "rapidity":0.8}
		},
		"maxQuantity":{"butchery":1},
		"full":{"EN":{"D":["I have too much boiled meat."]},
				"FR":{"D":["J'ai le maximum de viande bouillie."]}}
	},
	"intelligenceElixir":{
		"type":"item",
		"age":"steamAge",
		"category":"edible",
		"picture":{"file":"intelligenceElixir.atf"},
		"name":{"EN":"intelligence elixir",
				"FR":"élixir d'intelligence"},
		"description":{"EN":"The intelligence elixir used to temporary increase your intelligence and your willpower.",
					   "FR":"L'élixir d'intelligence augmente temporairement votre intelligence et votre volonté."},
		"use":{
			"quantity":-1,
			"gainTemporaryItem":{"increasedIntelligence":{"apothecary":3}},
			"xpSecondaryCharacteristic":{"willpower":8},
			"effect":"bonusEffect"
		},
		"maxQuantity":{"apothecary":1},
		"full":{"EN":{"D":["I have too many intelligence elixirs."]},
				"FR":{"D":["J'ai le maximum d'élixirs d'intelligence."]}},
		"produce":[{
				"workshop":"laboratory",
				"no":10,
				"time":8,
				"gainItem":{"intelligenceElixir":1},
				"sound":"soundBottle",
				"bonusSkill":"apothecary",
				"costRessource":{"crystals":4},
				"costPrimaryCharacteristic":{"stamina":16},
				"xpSecondaryCharacteristic":{"willpower":16},
				"xpSkill":{"apothecary":16},
				"repeat":true,
				"quantity":-8
		}]
	},
	"meatloaf":{
		"type":"item",
		"age":"goldenAge",
		"category":"edible",
		"picture":{"file":"meatloaf.atf"},
		"name":{"EN":"meatloaf",
				"FR":"pain de viande"},
		"description":{"EN":"meatloaf used to restore your stamina and gain a temporary bonus to strength and endurance.",
					   "FR":"Le pain de viande vous permet de récupérer de l'énergie et permet de gagner un bonus temporairement en force et en endurance."},
		"use":{
			"quantity":-1,
			"gainTemporaryItem":{"foodBonusMeatloaf":60},
			"gainPrimaryCharacteristic":{"stamina":{"strength":0.225, "endurance":0.225}},
			"xpSecondaryCharacteristic":{"strength":2.25, "endurance":2.25}
		},
		"maxQuantity":{"butchery":1},
		"full":{"EN":{"D":["I have too many meatloaf."]},
				"FR":{"D":["J'ai le maximum de pains de viande."]}}
	},
	"mixedPotion":{
		"type":"item",
		"age":"steamAge",
		"category":"edible",
		"picture":{"file":"mixedPotion.atf"},
		"name":{"EN":"mixed potion",
				"FR":"potion mixte"},
		"description":{"EN":"Mixed potion is a potion used to restore your health and mana.",
					   "FR":"La potion mixte vous permet de récupérer de la santé et de la mana."},
		"use":{
			"quantity":-1,
			"gainPrimaryCharacteristic":{"health":{"willpower":0.4}, "mana":{"willpower":0.4}},
			"xpSecondaryCharacteristic":{"willpower":8}
		},
		"maxQuantity":{"apothecary":1},
		"full":{"EN":{"D":["I have too many mixed potions."]},
				"FR":{"D":["J'ai le maximum de potions mixtes."]}},
		"produce":[{
				"workshop":"laboratory",
				"no":7,
				"time":8.5,
				"gainItem":{"mixedPotion":3},
				"sound":"soundBottle",
				"bonusSkill":"apothecary",
				"costRessource":{"medicinalHerbs":9, "crystals":2},
				"costPrimaryCharacteristic":{"stamina":17},
				"xpSecondaryCharacteristic":{"willpower":17},
				"xpSkill":{"apothecary":17},
				"repeat":true,
				"quantity":-8
		}]
	},
	"pastas":{
		"type":"item",
		"age":"steamAge",
		"category":"edible",
		"picture":{"file":"pastas.atf"},
		"name":{"EN":"pastas",
				"FR":"pâtes alimentaires"},
		"description":{"EN":"Pastas used to restore your stamina.",
					   "FR":"Les pâtes alimentaires vous permettent de récupérer de l'énergie."},
		"use":{
			"quantity":-1,
			"gainPrimaryCharacteristic":{"stamina":{"rapidity":0.3}},
			"xpSecondaryCharacteristic":{"rapidity":3}
		},
		"maxQuantity":{"bakery":1},
		"full":{"EN":{"D":["I have too many pastas."]},
				"FR":{"D":["J'ai le maximum de pâtes alimentaires."]}},
		"produce":[{
				"workshop":"windmill",
				"no":2,
				"time":1,
				"gainItem":{"pastas":1},
				"sound":"soundPick",
				"bonusSkill":"bakery",
				"costRessource":{"flour":1},
				"costPrimaryCharacteristic":{"stamina":2},
				"xpSecondaryCharacteristic":{"rapidity":2},
				"xpSkill":{"bakery":2},
				"repeat":true,
				"quantity":-2
		}]
	},
	"purifiedWater":{
		"type":"item",
		"age":"steamAge",
		"category":"edible",
		"picture":{"file":"purifiedWater.atf"},
		"name":{"EN":"purified water",
				"FR":"eau purifiée"},
		"description":{"EN":"Purified water used to restore your stamina and gain a temporary bonus to defense.",
					   "FR":"L'eau purifiée vous permet de récupérer de l'énergie et permet de gagner un bonus temporairement en défense."},
		"use":{
			"quantity":-1,
			"gainTemporaryItem":{"foodBonusPurifiedWater":60},
			"gainPrimaryCharacteristic":{"stamina":{"rapidity":0.2}},
			"xpSecondaryCharacteristic":{"rapidity":2}
		},
		"maxQuantity":{"alcohols":1},
		"full":{"EN":{"D":["I have too much purified water."]},
				"FR":{"D":["J'ai le maximum d'eau purifiée."]}},
		"produce":[{
				"workshop":"distillery",
				"no":3,
				"time":3,
				"gainItem":{"purifiedWater":3},
				"sound":"soundBottle",
				"bonusSkill":"alcohols",
				"costRessource":{"coal":1, "water":1},
				"costPrimaryCharacteristic":{"stamina":6},
				"xpSecondaryCharacteristic":{"address":6},
				"xpSkill":{"alcohols":6},
				"repeat":true,
				"quantity":-3
		}]
	},
	"sausage":{
		"type":"item",
		"age":"ironAge",
		"category":"edible",
		"picture":{"file":"sausage.atf"},
		"name":{"EN":"sausage",
				"FR":"saucisson"},
		"description":{"EN":"Sausage used to restore your stamina and gain a temporary bonus to endurance.",
					   "FR":"La saucisson vous permet de récupérer de l'énergie et permet de gagner un bonus temporairement en endurance."},
		"use":{
			"quantity":-1,
			"gainTemporaryItem":{"foodBonusSausage":60},
			"gainPrimaryCharacteristic":{"stamina":{"endurance":0.1}},
			"xpSecondaryCharacteristic":{"endurance":1}
		},
		"maxQuantity":{"butchery":1},
		"full":{"EN":{"D":["I have too many sausages."]},
				"FR":{"D":["J'ai le maximum de saucissons."]}}
	},
	"skewer":{
		"type":"item",
		"age":"steamAge",
		"category":"edible",
		"picture":{"file":"skewer.atf"},
		"name":{"EN":"skewer",
				"FR":"brochette"},
		"description":{"EN":"Skewer used to restore your stamina and gain a temporary bonus to attack.",
					   "FR":"La brochette vous permet de récupérer de l'énergie et permet de gagner un bonus temporairement en attaque."},
		"use":{
			"quantity":-1,
			"gainTemporaryItem":{"foodBonusSkewer":60},
			"gainPrimaryCharacteristic":{"stamina":{"endurance":0.18}},
			"xpSecondaryCharacteristic":{"endurance":1.8}
		},
		"maxQuantity":{"butchery":1},
		"full":{"EN":{"D":["I have too many skewers."]},
				"FR":{"D":["J'ai le maximum de brochettes."]}}
	},
	"steak":{
		"type":"item",
		"age":"stoneAge",
		"category":"edible",
		"picture":{"file":"steak.atf"},
		"name":{"EN":"steak",
				"FR":"steak"},
		"description":{"EN":"Steak used to restore your stamina and gain a temporary bonus to health.",
					   "FR":"Le steak vous permet de récupérer de l'énergie et permet de gagner un bonus temporairement en santé."},
		"use":{
			"quantity":-1,
			"gainTemporaryItem":{"foodBonusSteak":60},
			"gainPrimaryCharacteristic":{"stamina":{"endurance":0.16}},
			"xpSecondaryCharacteristic":{"endurance":1.6}
		},
		"maxQuantity":{"butchery":1},
		"full":{"EN":{"D":["I have too many steak."]},
				"FR":{"D":["J'ai le maximum de steak."]}}
	},
	"steamedBread":{
		"type":"item",
		"age":"steamAge",
		"category":"edible",
		"picture":{"file":"steamedBread.atf"},
		"name":{"EN":"steamed bread",
				"FR":"pain à la vapeur"},
		"description":{"EN":"Steamed bread used to restore your stamina and gain a temporary bonus to speed.",
					   "FR":"Le pain à la vapeur vous permet de récupérer de l'énergie et permet de gagner un bonus temporairement en vitesse."},
		"use":{
			"quantity":-1,
			"gainTemporaryItem":{"foodBonusSteamedBread":60},
			"gainPrimaryCharacteristic":{"stamina":{"rapidity":0.45}},
			"xpSecondaryCharacteristic":{"rapidity":4.5}
		},
		"maxQuantity":{"bakery":1},
		"full":{"EN":{"D":["I have too many steamed bread."]},
				"FR":{"D":["J'ai le maximum de pains à la vapeur."]}},
		"produce":[{
				"workshop":"bakeryOven",
				"time":6.5,
				"no":4,
				"gainItem":{"steamedBread":5},
				"sound":"soundPick",
				"bonusSkill":"bakery",
				"costRessource":{"flour":4, "coal":2},
				"costPrimaryCharacteristic":{"stamina":13},
				"xpSecondaryCharacteristic":{"rapidity":13},
				"xpSkill":{"bakery":13},
				"repeat":true,
				"quantity":-13
		}]
	},
	"strengthElixir":{
		"type":"item",
		"age":"steamAge",
		"category":"edible",
		"picture":{"file":"strengthElixir.atf"},
		"name":{"EN":"strength elixir",
				"FR":"élixir de force"},
		"description":{"EN":"The strength elixir used to temporary increase your strength and your endurance.",
					   "FR":"L'élixir de force augmente temporairement votre force et votre endurance."},
		"use":{
			"quantity":-1,
			"gainTemporaryItem":{"increasedStrength":{"apothecary":3}},
			"xpSecondaryCharacteristic":{"willpower":8},
			"effect":"bonusEffect"
		},
		"maxQuantity":{"apothecary":1},
		"full":{"EN":{"D":["I have too many strength elixirs."]},
				"FR":{"D":["J'ai le maximum d'élixirs de force."]}},
		"produce":[{
				"workshop":"laboratory",
				"no":8,
				"time":9,
				"gainItem":{"strengthElixir":1},
				"sound":"soundBottle",
				"bonusSkill":"apothecary",
				"costRessource":{"medicinalHerbs":18},
				"costPrimaryCharacteristic":{"stamina":18},
				"xpSecondaryCharacteristic":{"willpower":18},
				"xpSkill":{"apothecary":18},
				"repeat":true,
				"quantity":-9
		}]
	}
}